const express = require("express");
const faqController = require("../controllers/faqController");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

const router = express.Router();

// --- Public Routes (Protected by API Key only) ---
// Everyone can read FAQs
router.route("/").get(checkApiKey, faqController.getAllFAQs);

router.route("/:id").get(checkApiKey, faqController.getFAQ);

// --- Protected Routes (Admins Only) ---
// Only admins can create, update, or delete
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(faqController.createFAQ);

router
  .route("/:id")
  .patch(faqController.updateFAQ)
  .delete(faqController.deleteFAQ);

module.exports = router;
